/**
 * @file ttyInit.c
 * @provides ttyInit
 *
 * $Id: ttyInit.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <tty.h>
#include <stdlib.h>

struct tty ttytab[NTTY];

/**
 * Initialize TTY structures.
 * @param pdev TTY device table entry
 * @return OK if device is initialized
 */
devcall ttyInit(device * pdev)
{
    struct tty *ttyptr;

    pdev->controlblk = NULL;
    ttyptr = &ttytab[pdev->minor];
    bzero(ttyptr, sizeof(struct tty));

    return OK;
}
