/**
 * @file ttyOpen.c
 * @provides ttyOpen
 *
 * $Id: ttyOpen.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <tty.h>
#include <stdarg.h>

/**
 * Associate a TTY with a hardware device.
 * @param pdev TTY device table entry
 * @param ap 2nd argument is the device number for the hardware device
 * @return OK if TTY is opened properly, otherwise SYSERR
 */
devcall ttyOpen(device * pdev, va_list ap)
{
    struct tty *ttyptr = NULL;
    int dvnum = 0;

    /* Check if TTY is already open */
    if (NULL != pdev->controlblk)
    {
        return OK;
    }

    /* Second arg should be device index for physical hardware */
    dvnum = va_arg(ap, int);
    if (isbaddev(dvnum))
    {
        return SYSERR;
    }

    /* Setup pointer to tty */
    ttyptr = &ttytab[pdev->minor];

    /* Mutually link tty record with device table entry */
    pdev->controlblk = ttyptr;

    /* Initialize input buffer */
    ttyptr->istart = 0;
    ttyptr->icount = 0;
    ttyptr->idelim = FALSE;

    /* Initialize input and output flags */
    ttyptr->iflags = TTY_ICRNL;
    ttyptr->ieof = FALSE;
    ttyptr->oflags = TTY_ONLCR;

    ttyptr->tty_phw = &devtab[dvnum];

    return OK;
}
