/**
 * @file ttyPutc.c
 * @provides ttyPutc
 *
 * $Id: ttyPutc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <tty.h>

/**
 * Write a single character to a TTY.
 * @param pdev TTY device table entry
 * @param ch character to output
 * @return OK if character was written successfully, otherwise SYSERR
 */
devcall ttyPutc(device * pdev, char ch)
{
    struct tty *ttyptr;
    device *phw = NULL;

    /* Setup and error check pointers to structures */
    ttyptr = (struct tty *)pdev->controlblk;
    if (NULL == ttyptr)
    {
        return SYSERR;
    }

    phw = ttyptr->tty_phw;
    if (NULL == phw)
    {
        return SYSERR;
    }

    /* Cook special characters */
    switch (ch)
    {
        /* Newline */
    case '\n':
        if (ttyptr->oflags & TTY_ONLCR)
        {
            if (SYSERR == (*phw->putc) (phw, '\r'))
            {
                return SYSERR;
            }
        }
        break;
        /* Carriage return */
    case '\r':
        if (ttyptr->oflags & TTY_OCRNL)
        {
            ch = '\n';
        }
        break;
    }

    /* Write character to underlying device */
    return (*phw->putc) (phw, ch);
}
