/**
 * @file     ttyWrite.c
 * @provides ttyWrite
 *
 * $Id: ttyWrite.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <tty.h>

/**
 * Write a buffer to a tty
 * @param pdev TTY device table entry
 * @param buf buffer of characters to output
 * @param len size of the buffer
 * @return count of characters output
 */
devcall ttyWrite(device * pdev, void *buf, uint len)
{
    uchar ch = 0;
    uint count = 0;
    uchar *buffer = buf;

    /* Write all characters in buffer */
    while (count < len)
    {
        ch = *buffer++;
        if (SYSERR == ttyPutc(pdev, ch))
        {
            return SYSERR;
        }
        count++;
    }

    return count;
}
