/**
 * @file uartControl.c
 * @provides uartControl
 *
 * $Id: uartControl.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <uart.h>
#include <device.h>

/**
 * Control parameters to a UART.
 * @param pdev  pointer to UART device
 * @param func  index of function to run (defined in uart.h)
 * @param arg1  first argument to called function
 * @param arg2  second argument to called function
 */
devcall uartControl(device * pdev, int func, long arg1, long arg2)
{
    struct uart *puart = (struct uart *)pdev->controlblk;
    char old;

    switch (func)
    {

        /* Set input mode flags: arg1 = flags to set */
        /* return = old value of flags               */
    case UART_CTRL_SET_IFLAG:
        old = puart->iflags & arg1;
        puart->iflags |= arg1;
        return old;

        /* Clear input mode flags: arg1 = flags to clear */
        /* return = old value of flags */
    case UART_CTRL_CLR_IFLAG:
        old = puart->iflags & arg1;
        puart->iflags &= ~(arg1);
        return old;

        /* Get input flags: return = current value of flags */
    case UART_CTRL_GET_IFLAG:
        return puart->iflags;

        /* Set output mode flags: arg1 = flags to set */
        /*  return = old value of flags               */
    case UART_CTRL_SET_OFLAG:
        old = puart->oflags & arg1;
        puart->oflags |= arg1;
        return old;

        /* Clear output mode flags: arg1 = flags to clear */
        /* return = old value of flags                    */
    case UART_CTRL_CLR_OFLAG:
        old = puart->oflags & arg1;
        puart->oflags &= ~(arg1);
        return old;

        /* Get output flags: return = current value of flags */
    case UART_CTRL_GET_OFLAG:
        return puart->oflags;

        /* Determine if the UART transmitter is idle, return TRUE if idle */
    case UART_CTRL_OUTPUT_IDLE:
        return puart->oidle;

    }
    return SYSERR;
}
