/**
 * @file uartGetc.c
 * @provides uartGetc
 *
 * $Id: uartGetc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <uart.h>
#include <device.h>

/**
 * Read a single character from UART.
 * @param pdev pointer to UART device
 */
devcall uartGetc(device * pdev)
{
    uchar ch = 0;

    uartRead(pdev, &ch, 1);
    return ch;
}
