/**
 * @file uartPutc.c
 * @provides uartPutc
 *
 * $Id: uartPutc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <uart.h>
#include <device.h>

/**
 * Write a single character to the UART
 * @param  pdev  pointer to UART device
 * @param  ch    character to write 
 */
devcall uartPutc(device * pdev, char ch)
{
    return uartWrite(pdev, (void *)&ch, 1);
}
