/**
 * @file clock.h
 * Definitions relating to the hardware clock and the Xinu clock interrupt.
 *
 * $Id: clock.h 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#ifndef _CLOCK_H_
#define _CLOCK_H_

#include <queue.h>
#include <stddef.h>

#define CLKTICKS_PER_SEC  1000  /**< clock timer resolution             */

extern ulong clkticks;          /**< counts clock interrupts            */
extern ulong clktime;           /**< current time in secs since boot    */

extern qid_typ sleepq;          /**< queue for sleeping processes       */

/* Clock function prototypes */
void clkinit(void);
void clkupdate(ulong);
interrupt clkhandler(void);

#endif                          /* _CLOCK_H_ */
