/**
 * @file device.h 
 * @provides isbaddev
 *
 * Contains all definitions relating to the Xinu device subsystem.
 *
 * $Id: device.h 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

/* Device table declarations */
#ifndef _DEVICE_H_
#define _DEVICE_H_

#include <conf.h>
#include <stddef.h>

/**
 * Check that device id is between 0 and NDEVS. 
 *
 * @param f id number to test
 */
#define isbaddev(f)  ( !(0 <= (f) && (f) < NDEVS) )

/* Standard driver functions */
devcall close(int);
devcall control(int, int, long, long);
devcall getc(int);
devcall open(int, ...);
devcall putc(int, char);
devcall read(int, void *, uint);
devcall write(int, void *, uint);
devcall seek(int, uint);
syscall getdev(char *);

#endif                          /* _DEVICE_H_ */
