/**
 * @file loopback.h
 *
 * $Id: loopback.h 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#ifndef _LOOPBACK_H_
#define _LOOPBACK_H_

#include <device.h>
#include <stddef.h>
#include <semaphore.h>

#define LOOP_BUFFER 1024        /**< loopback buffer length             */

/**
 * Loopback device control block
 */
struct loopback
{
    int index;                  /**< index of first char in buffer      */
    semaphore sem;              /**< number of characters in buffer     */
    char buffer[LOOP_BUFFER];   /**< input buffer                       */
};

extern struct loopback looptab[];

/* Driver functions */
devcall loopbackInit(device *);
devcall loopbackOpen(device *);
devcall loopbackClose(device *);
devcall loopbackRead(device *, void *, uint);
devcall loopbackWrite(device *, void *, uint);
devcall loopbackGetc(device *);
devcall loopbackPutc(device *, char);

#endif                          /* _LOOPBACK_H_ */
