/**
 * @file memory.h
 * @provides roundmb, truncmb, stkfree
 *
 * $Id: memory.h 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#ifndef _MEMORY_H_
#define _MEMORY_H_

#include <stddef.h>

#define PAGE_SIZE 4096

/* roundmb - round address up to size of memblock  */
#define	roundmb(x)	(void *)( (7 + (ulong)(x)) & ~0x07 )
/* truncmb - truncate address down to size of memblock */
#define	truncmb(x)	(void *)( ((ulong)(x)) & ~0x07 )

#define stkfree(p, len) memfree((void *)((ulong)(p)         \
                                - (ulong)roundmb(len)       \
                                + (ulong)sizeof(ulong)),    \
                                (ulong)roundmb(len))

/**
 * Structure for a block of memory.
 */
struct memblock
{
    struct memblock *next;      /**< pointer to next memory block       */
    ulong length;               /**< size of memory block (with struct) */
};

extern struct memblock memlist; /**< head of free memory list           */

extern void *_end;              /**< linker provides end of image       */
extern void *memheap;           /**< bottom of heap                     */

/* Memory function prototypes */
void *memget(ulong);
syscall memfree(void *, ulong);
void *stkget(ulong);

#endif                          /* _MEMORY_H_ */
