/*
 * @file network.h
 *
 * $Id: network.h 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#ifndef _NETUTIL_H_
#define _NETUTIL_H_

#if BYTE_ORDER == BIG_ENDIAN
# define hs2net(x) (x)
# define net2hs(x) (x)
# define hl2net(x) (x)
# define net2hl(x) (x)
#else                           /* BYTE_ORDER == LITTLE_ENDIAN */
# define hs2net(x) ((((x)>>8) &0xff) | (((x) & 0xff)<<8))
# define net2hs(x) hs2net(x)
# define hl2net(x) ((((x)& 0xff)<<24) | (((x)>>24) & 0xff) | \
                   (((x) & 0xff0000)>>8) | (((x) & 0xff00)<<8))
# define net2hl(x) hl2net(x)
#endif                          /* BYTE_ORDER */

#endif                          /* _NETUTIL_H_ */
