/**
 * @file platform.h
 *
 * $Id: platform.h 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#ifndef _PLATFORM_H_
#define _PLATFORM_H_

#include <stddef.h>

/**
 * Various platform specific settings
 */
struct platform
{
    char name[16];
    void *maxaddr;
    ulong clkfreq;
    uchar uart_dll;
    uchar uart_irqnum;
};

extern struct platform platform;

/* Max RAM addresses */
#define MAXADDR_DEFAULT  0x00800000 /**< default  8MB RAM */
#define MAXADDR_WRT54G   0x00800000 /**< G    has 8MB RAM */
#define MAXADDR_WRT54GL  0x01000000 /**< GL   has 16MB RAM */
#define MAXADDR_WRT350N  0x02000000 /**< 350N has 32MB RAM */

/* Time Base Frequency */
#define CLKFREQ_DEFAULT  100000000
#define CLKFREQ_WRT54G   120000000
#define CLKFREQ_WRT54GL  100000000
#define CLKFREQ_WRT350N  150000000

/* UART DLL (Divisor Latch LS) */
#define UART_DLL_DEFAULT    0x0B
#define UART_DLL_WRT54G     0x0E
#define UART_DLL_WRT54GL    0x0B
#define UART_DLL_WRT350N    0x29

#endif                          /* _PLATFORM_H_ */
