/**
 * @file shell.h
 *
 * $Id: shell.h 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#ifndef _SHELL_H_
#define _SHELL_H_

#include <stddef.h>

/* Size contstants */
#define SHELL_BUFLEN  80        /**< length of general buffer           */
#define SHELL_MAXTOK  16        /**< maximum tokens per line            */
#define SHELL_CMDSTK  8192      /**< size of command proc. stack        */
#define SHELL_CMDPRIO 20        /**< command process priority           */

/* Message constants */
#define SHELL_BANNER  "\033[1;35m______________________________________\n    _    _  _____  ______   _     _ \n   \\ \\  / /(_____)|  ___ \\ | |   | |\n    \\ \\/ /    _   | |   | || |   | |\n     )  (    | |  | |   | || |   | |\n    / /\\ \\  _| |_ | |   | || |___| |\n   /_/  \\_\\(_____)|_|   |_| \\______|\n______________________________________\033[0;39m\n\n"
/** start message */
#define SHELL_START     "Welcome to the wonderful world of Xinu!\n"
#define SHELL_EXIT      "Shell closed.\n"  /**< exit message            */
#define SHELL_PROMPT    "xsh$ "            /**< prompt                  */
#define SHELL_SYNTAXERR "Syntax error.\n"  /**< syntax error            */
#define SHELL_CHILDERR  "Cannot create.\n" /**< command error           */

/**
 * Defines what an entry in the shell command table looks like.
 */
struct centry
{
    char *name;                 /**< name of command                    */
    bool builtin;               /**< built-in command?                  */
    shellcmd (*procedure) (int, char *[]);/**< procedure                */
};

/* Token parsing functions */
#define isEndOfLine(c)    ((c) == '\0' || (c) == '\r' || (c) == '\n')
#define isQuote(c)        ((c) == '"' || (c) == '\'')
#define isOtherSpecial(c) ((c) == '<' || (c) == '>' || (c) == '&')
#define isWhitespace(c)   ((c) == ' ' || (c) == '\t')

extern struct centry commandtab[];   /**< table of commands             */
extern ulong ncommand;               /**< number of commands in table   */

/* Function prototypes */
thread shell(int);
short lexan(char *, ushort, char *, char *[]);
shellcmd xsh_arp(int, char *[]);
shellcmd xsh_clear(int, char *[]);
shellcmd xsh_date(int, char *[]);
shellcmd xsh_ethstat(int, char *[]);
shellcmd xsh_exit(int, char *[]);
shellcmd xsh_gpiostat(int, char *[]);
shellcmd xsh_help(int, char *[]);
shellcmd xsh_kill(int, char *[]);
shellcmd xsh_led(int, char *[]);
shellcmd xsh_memstat(int, char *[]);
shellcmd xsh_memdump(int, char *[]);
shellcmd xsh_netinfo(int, char *[]);
shellcmd xsh_netopen(int, char *[]);
shellcmd xsh_netclose(int, char *[]);
shellcmd xsh_nslookup(int, char *[]);
shellcmd xsh_ping(int, char *[]);
shellcmd xsh_ps(int, char *[]);
shellcmd xsh_reset(int, char *[]);
shellcmd xsh_rdate(int, char *[]);
shellcmd xsh_route(int, char *[]);
shellcmd xsh_setdns(int, char *[]);
shellcmd xsh_sleep(int, char *[]);
shellcmd xsh_snoop(int, char *[]);
shellcmd xsh_test(int, char *[]);
shellcmd xsh_testsuite(int, char *[]);
shellcmd xsh_traceroute(int, char *[]);
shellcmd xsh_uartstat(int, char *[]);
shellcmd xsh_vlanstat(int, char *[]);
shellcmd xsh_nvram(int, char *[]);

#endif                          /* _SHELL_H_ */
