/**
 * @file bzero.c
 * @provides bzero
 *
 * $Id: bzero.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

/**
 * Clears a block of characters to 0s
 * @param *p pointer to start of block
 * @param len length of the block
 */
void bzero(void *p, int len)
{
    int n;
    char *pch = (char *)p;

    if ((n = len) <= 0)
    {
        return;
    }
    do
    {
        *pch++ = 0;
    }
    while (--n);
}
