/**
 * @file fputs.c
 * @provides fputs
 *
 * $Id: fputs.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

extern int putc(int, char);

/**
 * Write a null-terminated string to a device (file)
 * @param dev device to write to
 * @param *s string to write
 * @return result of last putc
 */
int fputs(char *s, int dev)
{
    int r = 0, c;

    while ((c = (*s++)))
    {
        r = putc(dev, c);
    }
    return r;
}
