/**
 * @file free.c
 * @provides free
 *
 * $Id: free.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <memory.h>

/**
 * Attempt to free block of memory based on malloc() accounting
 * information stored in preceding two words.
 * @param *pmem pointer to memory block
 * @return OK on success, SYSERR on failure
 */
void free(void *pmem)
{
    struct memblock *block;

    /* block points at the memblock we want to free */
    block = (struct memblock *)pmem;

    /* back up to accounting information */
    block--;

    /* don't memfree if we fail basic checks */
    if (block->next != block)
    {
        return;
    }

    memfree(block, block->length);
}
