/**
 * @file malloc.c
 * @provides malloc.c
 *
 * $Id: malloc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <memory.h>

/**
 * Request heap storage, record accounting information, returning pointer
 * to assigned memory region.
 * @param nbytes number of bytes requested
 * @return pointer to region on success, SYSERR on failure
 */
void *malloc(ulong nbytes)
{
    struct memblock *pmem;

    /* we don't allocate 0 bytes. */
    if (0 == nbytes)
    {
        return NULL;
    }

    /* make room for accounting info */
    nbytes += sizeof(struct memblock);

    /* acquire memory from kernel */
    pmem = (struct memblock *)memget(nbytes);
    if (SYSERR == (uint)pmem)
    {
        return NULL;
    }

    /* set accounting info */
    pmem->next = pmem;
    pmem->length = nbytes;

    return (void *)(pmem + 1);  /* +1 to skip accounting info */
}
