/**
 * @file memset.c
 * @provides memset
 *
 * $Id: memset.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

/** 
 * Place a character into first n characters.
 * @param s memory to place character into
 * @param c character to place
 * @param n number of times to place character
 * @return the pointer to memory
 */
void *memset(void *s, int c, int n)
{
    register int i;
    char *cp = (char *)s;

    for (i = 0; i < n; i++)
    {
        *cp = (unsigned char)c;
        cp++;
    }
    return s;
}
