/**
 * @file printf.c
 * @provides printf
 *
 * $Id: printf.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stdio.h>
#include <stdarg.h>

int printf(const char *fmt, ...)
{
    va_list ap;
    int putc(int, int);

    va_start(ap, fmt);
    _doprnt((char *)fmt, ap, putc, stdout);
    va_end(ap);

    return 0;
}
