/**
 * @file rand.c
 * @provides srand, rand
 *
 * $Id: rand.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

static unsigned long randx = 1;

/**
 * Sets the random seed.
 * @param x random seed
 */
void srand(unsigned long x)
{
    randx = x;
}

/**
 * Generates a random long.
 * @return random long
 */
unsigned long rand(void)
{
    return (((randx = randx * 1103515245 + 12345) >> 16) & 077777);
}
