/**
 * @file strcat.c
 * @provides strcat
 *
 * $Id: strcat.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

/*
 * Concatenate s2 on the end of s1.  S1's space must be large enough.
 * @param s1 first string
 * @param s2 second string
 * @return s1.
 */
char *strcat(char *s1, const char *s2)
{
    char *os1 = s1;
    const char *os2 = s2;

    while (*os1++)
    {;
    }
    --os1;
    while (((*os1++) = (*os2++)))
    {;
    }
    return s1;
}
