/**
 * @file strchr.c
 * @provides strchr
 *
 * $Id: strchr.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

/** 
 * Returns a pointer to the location in a string at which which a particular
 * character appears.
 * @param *s string to search
 * @param c character to locate
 * @return the pointer in the string, NULL if character not found
 */
char *strchr(const char *s, int c)
{
    for (; *s != '\0'; s++)
    {
        if (*s == (const char)c)
        {
            return (char *)s;
        }
    }

    if ((const char)c == *s)
    {
        return (char *)s;
    }

    return 0;
}
