/**
 * @file strcmp.c
 * @provides strcmp
 *
 * $Id: strcmp.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

/**
 * Compare strings.
 * @param *s1 first memory location
 * @param *s2 second memory location
 * @return s1>s2: >0  s1==s2: 0  s1<s2: <0
 */
int strcmp(const char *s1, const char *s2)
{

    while (*s1 == *s2++)
        if (*s1++ == '\0')
            return (0);
    return (*s1 - *--s2);
}
