/**
 * @file strcpy.c
 * @provides strcpy
 *
 * $Id: strcpy.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

/**
 * Copy string s2 to s1.  s1 must be large enough.
 * @param s1 first string
 * @param s2 second string
 * @return s1
 */
char *strcpy(char *s1, const char *s2)
{
    char *os1;

    os1 = s1;
    while (((*s1++) = (*s2++)))
        ;
    return (os1);
}
