/**
 * @file strnlen.c
 * @provides strnlen
 *
 * $Id: strnlen.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

/**
 * Returns the number of non-NULL bytes in a string or len.
 * @param *s string
 * @param len length you wish to scan s too
 * @return length of the string up to user specified length
 */
int strnlen(const char *s, unsigned int len)
{
    int n;

    n = 0;
    while (*s++ && n < len)
        n++;

    return (n);
}
