/**
 * @file mailboxInit.c
 * @provides mailboxInit
 *
 * $Id: mailboxInit.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <mailbox.h>

struct mbox mboxtab[NMAILBOX];
semaphore mboxtabsem;

/**
 * Initialize mailbox structures.
 * @return OK if all mailboxes are initialized successfully
 */
syscall mailboxInit(void)
{
    int i = 0;

    mboxtabsem = semcreate(1);

    /* set all mailbox states to MAILBOX_FREE */
    for (i = 0; i < NMAILBOX; i++)
    {
        mboxtab[i].state = MAILBOX_FREE;
    }

    return OK;
}
