/**
 * @file     xsh_clear.c
 * @provides xsh_clear
 *
 * $Id: xsh_clear.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <stdio.h>
#include <string.h>

/**
 * Shell command (clear) clears the terminal using vt100 terminal control.
 * @param nargs number of arguments
 * @param args  array of arguments
 * @return non-zero value on error
 */
shellcmd xsh_clear(int nargs, char *args[])
{
    /* Output help, if '--help' argument was supplied */
    if (nargs == 2 && strncmp(args[1], "--help", 6) == 0)
    {
        fprintf(stdout, "Usage: clear\n");
        fprintf(stdout, "Clears the terminal.\n");
        fprintf(stdout, "\t--help\t display this help and exit\n");
        return 1;
    }

    /* Check for correct number of arguments */
    if (nargs > 1)
    {
        fprintf(stderr, "clear: too many arguments\n");
        fprintf(stderr, "Try 'clear --help' for more information.\n");
        return 1;
    }

    fprintf(stdout, "\033[2J\033[H\n");
    return 0;
}
