/**
 * @file     xsh_exit.c
 * @provides xsh_exit
 *
 * $Id: xsh_exit.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <shell.h>
#include <stdio.h>
#include <string.h>
#include <thread.h>

/**
 * Shell command (exit) closes the shell.
 * @param nargs number of arguments in args array
 * @param args  array of arguments
 * @return non-zero value on error
 */
shellcmd xsh_exit(int nargs, char *args[])
{
    /* Output help, if '--help' argument was supplied */
    if (nargs == 2 && strncmp(args[1], "--help", 6) == 0)
    {
        fprintf(stdout, "Usage: exit\n");
        fprintf(stdout, "Closes the Xinu shell.\n");
        fprintf(stdout, "\t--help\t display this help and exit\n");
        return 1;
    }

    /* Check for correct number of arguments */
    if (nargs > 1)
    {
        fprintf(stderr, "exit: too many arguments\n");
        fprintf(stderr, "Try 'exit --help' for more information.\n");
        return 1;
    }

    fprintf(stdout, SHELL_EXIT);
    sleep(10);
    kill(gettid());

    return 0;
}
