/**
 * @file     xsh_reset.c
 * @provides xsh_reset
 *
 * $Id: xsh_reset.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <gpio.h>
#include <stdio.h>
#include <string.h>

/**
 * Shell command (reset) performs a soft restart of the router.
 * @param nargs number of arguments in args array
 * @param args  array of arguments
 * @return non-zero value on error
 */
shellcmd xsh_reset(int nargs, char *args[])
{
    struct gpio_csreg *pgcsr;   /* pointer to gpio registers     */

    /* Output help, if '--help' argument was supplied */
    if (nargs == 2 && strncmp(args[1], "--help", 6) == 0)
    {
        fprintf(stdout, "Usage: reset\n");
        fprintf(stdout, "Performs a soft reset of the router.\n");
        fprintf(stdout, "\t--help\t display this help and exit\n");
        return 1;
    }

    /* Check for correct number of arguments */
    if (nargs > 1)
    {
        fprintf(stderr, "reset: too many arguments\n");
        fprintf(stderr, "Try 'reset --help' for more information\n");
        return 1;
    }

    /* Initialize pointers */
    pgcsr = (struct gpio_csreg *)GPIO_BASE;

    /* Reset router */
    pgcsr->input |= GPIO_BUT_RESET;

    return 0;
}
