/**
 * @file bfpfree.c
 * @provides bfpfree
 *
 * $Id: bfpfree.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <interrupt.h>
#include <memory.h>
#include <bufpool.h>

syscall bfpfree(int id)
{
    struct bfpentry *bfpptr;
    irqmask im;

    if (isbadpool(id))
    {
        return SYSERR;
    }

    bfpptr = &bfptab[id];

    im = disable();
    bfpptr->state = BFPFREE;
    if (SYSERR == memfree(bfpptr->head, bfpptr->nbuf * bfpptr->bufsize))
    {
        restore(im);
        return SYSERR;
    }
    if (SYSERR == semfree(bfpptr->freebuf))
    {
        restore(im);
        return SYSERR;
    }
    restore(im);

    return OK;
}
