/**
 * @file chprio.c
 * @provides chprio
 *
 * $Id: chprio.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <thread.h>

/**
 * Change the scheduling priority of a thread
 * @param tid target thread
 * @param newprio new priority
 * @return old priority of thread
 */
syscall chprio(tid_typ tid, int newprio)
{
    register struct thrent *thrptr;     /* thread control block */
    irqmask im;
    int oldprio;

    im = disable();
    if (isbadtid(tid))
    {
        restore(im);
        return SYSERR;
    }
    thrptr = &thrtab[tid];
    oldprio = thrptr->prio;
    thrptr->prio = newprio;
    restore(im);
    return oldprio;
}
