/**
 * @file close.c
 * @provides close
 *
 * $Id: close.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>

/**
 * close a device
 * @param descrp definition of device to close
 * @return function to close device on success, SYSERR on failure
 */
devcall close(int descrp)
{
    device *devptr;

    if (isbaddev(descrp))
    {
        return SYSERR;
    }
    devptr = &devtab[descrp];
    return ((*devptr->close) (devptr));
}
