/**
 * @file debugbreak.S
 * @provides access to the assembly debug breakpoint command
 *    that drops straight into debug mode
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <mips.h>

.text
	.align 4	
	.globl debugbreak	

/**
 * @fn void debugbreak(void)
 * Inserts breakpoint and drops into debug mode.  Stores return address to
 * jump back to it if process returns from breakpoint.
 */
	.ent debugbreak
debugbreak:
	.set noreorder
	addiu sp,sp,-4
	sw    ra, 4(sp)
	sdbbp
	lw    ra, 4(sp)
	addiu sp,sp,4
	jr    ra
	.set reorder
	.end debugbreak
