/**
 * @file getc.c
 * @provides getc
 *
 * $Id: getc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>

/**
 * get one character from a device
 * @param descrp definition of device from which to acquire character
 * @return function to get character on success, SYSERR on failure
 */
devcall getc(int descrp)
{
    device *devptr;

    if (isbaddev(descrp))
    {
        return SYSERR;
    }
    devptr = &devtab[descrp];
    return ((*devptr->getc) (devptr));
}
