/**
 * @file     getdev.c
 * @provides getdev
 *
 * $Id: getdev.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>
#include <string.h>

/**
 * Returns the numerical identifier for the given device.
 * @param *dev device name
 * @return device number
 */
syscall getdev(char *dev)
{
    int devnum;

    for (devnum = 0; devnum < NDEVS; devnum++)
    {
        if (0 == strncmp(dev, devtab[devnum].name, DEVMAXNAME))
        {
            return devnum;
        }
    }

    return SYSERR;
}
