/**
 * @file insert.c
 * @provides insert
 *
 * $Id: insert.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <thread.h>
#include <queue.h>

/**
 * Insert a thread into a queue in descending key order.
 * @param tid    thread ID to insert
 * @param q      target queue
 * @param key    sorting key
 * @return OK
 */
int insert(tid_typ tid, qid_typ q, int key)
{
    int next;                   /* runs through list         */
    int prev;                   /* follows next through list */

    if (isbadqid(q) || isbadtid(tid))
    {
        return SYSERR;
    }

    next = quetab[quehead(q)].next;
    while (quetab[next].key >= key)
    {
        next = quetab[next].next;
    }

    /* insert tid between prev and next */
    quetab[tid].next = next;
    quetab[tid].prev = prev = quetab[next].prev;
    quetab[tid].key = key;
    quetab[prev].next = tid;
    quetab[next].prev = tid;
    return OK;
}
