/**
 * @file     main.c
 * @provides main
 *
 * $Id: main.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <stdio.h>
#include <ether.h>
#include <thread.h>
#include <device.h>

extern void shell(int);

extern ulong cpuid;

int main(int argc, char **argv)
{
    int i = 0;

    /* Associate TTY1 with second serial port. */
    open(TTY1, SERIAL1);

    /* Open all ethernet devices and one network interface */
    for (i = 0; i < NETHER; i++)
    {
        /* Open the underlying ethernet device */
        if (SYSERR == open(ethertab[i].dev->num))
        {
            kprintf
                ("Failed to open ethernet device %s\r\n",
                 ethertab[i].dev->name);
        }
    }

    /* Launch one shell process for each TTY device. */
    ready(create
          ((void *)shell, INITSTK, INITPRIO, "SHELL0", 1,
           CONSOLE), RESCHED_NO);
    ready(create
          ((void *)shell, INITSTK, INITPRIO, "SHELL1", 1,
           TTY1), RESCHED_NO);
    return 0;
}
