/**
 * @file putc.c
 * @provides putc
 *
 * $Id: putc.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>

/**
 * write a single character to a device
 * @param descrp definition of device on which to write
 * @param ch character to write
 * @return function to write character on success, SYSERR on failure
 */
devcall putc(int descrp, char ch)
{
    device *devptr;

    if (isbaddev(descrp))
    {
        return SYSERR;
    }
    devptr = &devtab[descrp];
    return ((*devptr->putc) (devptr, ch));
}
