/**
 * @file receive.c
 * @provides receive
 *
 * $Id: receive.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <thread.h>

/**
 * receive - wait for a message and return it
 * @return message
 */
message receive(void)
{
    register struct thrent *thrptr;
    irqmask im;
    message msg;

    im = disable();
    thrptr = &thrtab[thrcurrent];
    if (FALSE == thrptr->hasmsg)
    {                           /* if no message, wait for one */
        thrptr->state = THRRECV;
        resched();
    }
    msg = thrptr->msg;          /* retrieve message                */
    thrptr->hasmsg = FALSE;     /* reset message flag              */
    restore(im);
    return msg;
}
