/**
 * @file semcount.c
 * @provides semcount
 *
 * $Id: semcount.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <semaphore.h>

/**
 * Return a semaphore's count
 * @param sem    target semaphore
 * @return count from semtab entry on success, SYSERR on failure
 */
syscall semcount(semaphore sem)
{
    if (isbadsem(sem))
    {
        return SYSERR;
    }

    return (semtab[sem].count);
}
