/**
 * @file semfree.c
 * @provides semfree
 *
 * $Id: semfree.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <thread.h>

/**
 * Deallocate a semaphore.
 * Reset the semaphore count, releasing any threads
 * in the waiting queue.  Deallocate entry in global
 * semaphore table.
 * @param sem  target semaphore
 * @return OK on success, SYSERR on failure
 */
syscall semfree(semaphore sem)
{
    register struct sement *semptr;
    irqmask im;
    tid_typ tid;

    im = disable();
    if (isbadsem(sem))
    {
        restore(im);
        return SYSERR;
    }

    semptr = &semtab[sem];
    while (nonempty(semptr->queue))
    {
        tid = dequeue(semptr->queue);   /* free waiting threads */
        ready(tid, RESCHED_NO);
    }

    semptr->count = 0;
    semptr->state = SFREE;
    restore(im);
    return OK;
}
