/**
 * @file sleep.c
 * @provides sleep
 *
 * $Id: sleep.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <kernel.h>
#include <stddef.h>
#include <interrupt.h>
#include <thread.h>
#include <queue.h>
#include <clock.h>

/**
 * Delay the calling thread n ticks.
 * @param ms number of milliseconds to sleep
 * @return OK if thread is sleeping, SYSERR if no clock
 */
syscall sleep(uint ms)
{
#ifdef RTCLOCK
    irqmask im;
    int ticks = 0;

    ticks = (CLKTICKS_PER_SEC / 1000) * ms;

    im = disable();
    if (ticks > 0)
    {
        if (SYSERR == insertd(thrcurrent, sleepq, ticks))
        {
            restore(im);
            return SYSERR;
        }
        thrtab[thrcurrent].state = THRSLEEP;
    }

    resched();
    restore(im);
    return OK;
#else
    return SYSERR;
#endif
}
