/**
 * @file unistd.c
 * @provides getnum, printnum
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stdio.h>
#include <stdarg.h>

syscall getnum(void)
{
    int i = 0, c = 0;

    control(CONSOLE, TTY_IOC_SETIFLAG, TTY_IFLAG_ECHO);
    fprintf(CONSOLE, "? ");

    c = getchar();
    while (('\n' != c) && ('\r' != c) && (EOF != c))
    {
        if (('0' <= c) && ('9' >= c))
        {
            i = i * 10 + c - '0';
        }

        c = getchar();
    }

    if (EOF == c)
        return c;

    return i;
}

syscall printnum(int i)
{
    return fprintf(CONSOLE, "%d\n", i);
}
