/**
 * @file wait.c
 * @provides wait
 *
 * $Id: wait.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <thread.h>

/**
 * Make current process wait on a semaphore
 * @param sem  target semaphore
 * @return OK on success, SYSERR on failure
 */
syscall wait(semaphore sem)
{
    register struct sement *semptr;
    register struct thrent *thrptr;
    irqmask im;

    im = disable();
    if (isbadsem(sem))
    {
        restore(im);
        return SYSERR;
    }
    thrptr = &thrtab[thrcurrent];
    semptr = &semtab[sem];
    if (--(semptr->count) < 0)
    {
        thrptr->state = THRWAIT;
        thrptr->sem = sem;
        enqueue(thrcurrent, semptr->queue);
        resched();
    }
    restore(im);
    return OK;
}
