/**
 * @file wakeup.c
 * @provides wakeup
 *
 * $Id: wakeup.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <thread.h>
#include <queue.h>
#include <clock.h>

/**
 * Wakeup and ready all threads that have no more time to sleep
 */
void wakeup(void)
{
    while (nonempty(sleepq) && (firstkey(sleepq) <= 0))
    {
        ready(dequeue(sleepq), RESCHED_NO);
    }

    resched();
}
