/**
 * @file write.c
 * @provides write
 *
 * $Id: write.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stddef.h>
#include <device.h>

/**
 * write 1 or more bytes to a device
 * @param descrp definition of device on which to write
 * @param *buffer pointer to data to be written
 * @param count length of data to be written
 * @return function to write data on success, SYSERR on failure
 */
devcall write(int descrp, void *buffer, uint count)
{
    device *devptr;

    if (isbaddev(descrp))
    {
        return SYSERR;
    }
    devptr = &devtab[descrp];
    return ((*devptr->write) (devptr, buffer, count));
}
