/**
 * @file xdone.c
 * @provides xdone
 *
 * $Id: xdone.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <stdio.h>
#include <gpio.h>

extern void halt(void);

/**
 * Print system completion message as last thread exits.
 */
void xdone(void)
{
    kprintf("\r\n\r\nAll user processes have completed.\r\n\r\n");
    gpioLEDOff(GPIO_LED_CISCOWHT);
    disable();
    halt();
}
