/**
 * @file yield.c
 * @provides yield
 *
 * $Id: yield.c 1577 2008-10-03 18:19:26Z mschul $
 */
/* Embedded Xinu, Copyright (C) 2008.  All rights reserved. */

#include <thread.h>

/**
 * Yield processor.
 * @return OK when the thread is context switched back
 */
syscall yield(void)
{
    irqmask im;

    im = disable();
    resched();
    restore(im);
    return OK;
}
