#include <stddef.h>
#include <stdio.h>
#include <testsuite.h>

/**< table of test cases */
struct testcase testtab[] = {
    {"Argument Passing", test_bigargs},
    {"Priority Scheduling", test_schedule},
    {"Thread Preemption", test_preempt},
    {"Recursion", test_recursion},
    {"Single Semaphore", test_semaphore},
    {"Multiple Semaphores", test_semaphore2},
    {"Counting Semaphores", test_semaphore3},
    {"Killing Semaphores", test_semaphore4},
    {"Process Queues", test_procQueue},
    {"Delta Queues", test_deltaQueue},
    {"Standard Input/Output", test_libStdio},
    {"Character Types", test_libCtype},
    {"String Library", test_libString},
    {"Standard Library", test_libStdlib},
    {"Type Limits", test_libLimits},
    {"TTY Driver", test_ttydriver},
    {"Ethernet Driver", test_ether},
    {"Memory", test_memory},
    {"Buffer Pool", test_bufpool},
    {"NVRAM", test_nvram},
    {"System", test_system},
    {"Mailbox", test_mailbox},
    {"Message Passing", test_messagePass},
};

int ntests = sizeof(testtab) / sizeof(struct testcase);

void testPass(bool verbose, const char *msg)
{
    if (TRUE == verbose)
    {
        printf("\033[40G[\033[1;32mPASSED\033[0;39m] %s\n", msg);
    }
}

void testFail(bool verbose, const char *msg)
{
    if (TRUE == verbose)
    {
        printf("\033[40G[\033[1;31mFAILED\033[0;39m] %s\n", msg);
    }
}

void testPrint(bool verbose, const char *msg)
{
    if (TRUE == verbose)
    {
        printf("  %s", msg);
    }
}
